/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.rake;

import com.aptana.core.ShellExecutable;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ProcessUtil;
import com.aptana.ruby.internal.rake.Messages;
import com.aptana.ruby.internal.rake.RakeFileFinder;
import com.aptana.ruby.launching.RubyLaunchingPlugin;
import com.aptana.ruby.rake.IRakeHelper;
import com.aptana.ruby.rake.RakePlugin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;

public class RakeTasksHelper
implements IRakeHelper {
    private static final String RUBY_EXE_NAME = "ruby";
    private static final String TASK_LIST_SWITCH = "--tasks";
    private static final Pattern RAKE_TASK_PATTERN = Pattern.compile("^rake\\s+([\\w:]+)\\s+#\\s+(.+)$");
    private static final String ENV_MODIFYING_PARAM = "RAILS_ENV";
    private Map<IProject, Map<String, String>> fCachedTasks = new HashMap<IProject, Map<String, String>>();

    private IStatus runRakeInBackground(IProject project, IProgressMonitor monitor, String ... arguments) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        IPath wd = this.getWorkingDirectory(project);
        IPath rubyExe = RubyLaunchingPlugin.rubyExecutablePath((IPath)wd);
        Map<String, String> env = !"win32".equals(Platform.getOS()) ? ShellExecutable.getEnvironment((IPath)wd) : new HashMap<String, String>();
        env = this.modifyEnv(env, arguments);
        ArrayList<String> args = new ArrayList<String>();
        args.add(RakePlugin.getDefault().getRakePath(project));
        if (arguments != null) {
            String[] stringArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                args.add(param);
                ++n2;
            }
        }
        return ProcessUtil.runInBackground((String)(rubyExe == null ? RUBY_EXE_NAME : rubyExe.toOSString()), (IPath)wd, env, (String[])args.toArray(new String[args.size()]));
    }

    private IPath getWorkingDirectory(IProject project) {
        if (project == null) {
            return null;
        }
        try {
            RakeFileFinder finder = new RakeFileFinder();
            project.accept((IResourceProxyVisitor)finder, 0);
            IPath workingDir = finder.getWorkingDirectory();
            if (workingDir != null) {
                return project.getLocation().append(workingDir);
            }
            if (IdeLog.isWarningEnabled((Plugin)RakePlugin.getDefault(), null)) {
                IdeLog.logWarning((Plugin)RakePlugin.getDefault(), (String)("Failed to find parent of Rakefile to use as working dir for project: " + project.getName()));
            }
        }
        catch (CoreException e) {
            RakePlugin.log((Exception)((Object)e));
        }
        return project.getLocation();
    }

    @Override
    public Map<String, String> getTasks(IProject project, IProgressMonitor monitor) {
        return this.getTasks(project, false, monitor);
    }

    @Override
    public Map<String, String> getTasks(IProject project, boolean force, IProgressMonitor monitor) {
        if (!force && this.fCachedTasks.containsKey(project)) {
            return Collections.unmodifiableMap(this.fCachedTasks.get(project));
        }
        if (monitor != null && monitor.isCanceled()) {
            return Collections.emptyMap();
        }
        BufferedReader bufReader = null;
        try {
            try {
                bufReader = new BufferedReader(new StringReader(this.getTasksText(project)));
                String line = null;
                HashMap<String, String> tasks = new HashMap<String, String>();
                while ((line = bufReader.readLine()) != null) {
                    Matcher mat = RAKE_TASK_PATTERN.matcher(line);
                    if (!mat.matches()) continue;
                    tasks.put(mat.group(1), mat.group(2));
                }
                this.fCachedTasks.put(project, tasks);
            }
            catch (IOException e) {
                RakePlugin.log("Error parsing rake tasks", e);
                Map<String, String> map = Collections.emptyMap();
                if (bufReader != null) {
                    try {
                        bufReader.close();
                    }
                    catch (IOException iOException) {}
                }
                return map;
            }
        }
        catch (Throwable throwable) {
            if (bufReader != null) {
                try {
                    bufReader.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (bufReader != null) {
            try {
                bufReader.close();
            }
            catch (IOException iOException) {}
        }
        return this.fCachedTasks.get(project);
    }

    private String getTasksText(IProject project) {
        IStatus status = this.runRakeInBackground(project, (IProgressMonitor)new NullProgressMonitor(), TASK_LIST_SWITCH);
        if (status.isOK()) {
            return status.getMessage();
        }
        return "";
    }

    @Override
    public IStatus runRake(IProject project, IProgressMonitor monitor, String ... arguments) {
        try {
            ILaunchConfiguration config = this.findOrCreateLaunchConfiguration(project, arguments);
            if (config == null) {
                return new Status(4, "com.aptana.ruby.rake", MessageFormat.format(Messages.RakeTasksHelper_LaunchGenerationFailed, project, arguments));
            }
            DebugUITools.launch((ILaunchConfiguration)config, (String)"run");
        }
        catch (CoreException e) {
            RakePlugin.log((Exception)((Object)e));
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private Map<String, String> modifyEnv(Map<String, String> env, String ... arguments) {
        HashMap<String, String> modified = new HashMap<String, String>(env);
        if (arguments != null) {
            String[] stringArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                if (param.contains("RAILS_ENV=")) {
                    String value = param.substring(param.indexOf("RAILS_ENV=") + 10);
                    if (value.indexOf(32) != -1) {
                        value = value.substring(0, value.indexOf(32));
                    }
                    modified.put(ENV_MODIFYING_PARAM, value);
                }
                ++n2;
            }
        }
        return modified;
    }

    private ILaunchConfiguration findOrCreateLaunchConfiguration(IProject project, String ... arguments) throws CoreException {
        String rakeScriptPath = RakePlugin.getDefault().getRakePath(project);
        IPath wd = this.getWorkingDirectory(project);
        Map<String, String> env = this.modifyEnv(new HashMap<String, String>(), arguments);
        StringBuilder args = new StringBuilder();
        if (arguments != null && arguments.length > 0) {
            String[] stringArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                String argument = stringArray[n2];
                args.append(argument).append(' ');
                ++n2;
            }
            args.deleteCharAt(args.length() - 1);
        }
        ILaunchConfigurationType configType = this.getRubyLaunchConfigType();
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configType);
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
        ILaunchConfiguration[] iLaunchConfigurationArray = configs;
        int n = configs.length;
        int n3 = 0;
        while (n3 < n) {
            boolean envMatches;
            boolean argsMatch;
            ILaunchConfiguration config = iLaunchConfigurationArray[n3];
            boolean absoluteFilenamesMatch = config.getAttribute("com.aptana.ruby.debug.ATTR_FILE_NAME", "").equals(rakeScriptPath);
            if (absoluteFilenamesMatch && (argsMatch = config.getAttribute("com.aptana.ruby.debug.ATTR_PROGRAM_ARGUMENTS", "").equals(args.toString())) && (envMatches = env.equals(config.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null)))) {
                candidateConfigs.add(config);
            }
            ++n3;
        }
        switch (candidateConfigs.size()) {
            case 0: {
                return this.createConfiguration(project, wd, rakeScriptPath, args.toString(), env);
            }
            case 1: {
                return (ILaunchConfiguration)candidateConfigs.get(0);
            }
        }
        Status status = new Status(2, "com.aptana.ruby.rake", 0, "Multiple configurations match", null);
        throw new CoreException((IStatus)status);
    }

    private ILaunchConfiguration createConfiguration(IProject project, IPath workingDir, String rubyFile, String args, Map<String, String> env) throws CoreException {
        ILaunchConfigurationType configType = this.getRubyLaunchConfigType();
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(MessageFormat.format("{0} rake {1}", project.getName(), args)));
        wc.setAttribute("com.aptana.ruby.debug.ATTR_FILE_NAME", rubyFile);
        wc.setAttribute("com.aptana.ruby.debug.ATTR_WORKING_DIR", workingDir.toOSString());
        wc.setAttribute("com.aptana.ruby.debug.ATTR_PROGRAM_ARGUMENTS", args);
        wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, "com.aptana.ruby.debug.core.sourceLocator");
        wc.setAttribute("org.eclipse.debug.ui.private", true);
        wc.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
        wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, env);
        return wc.doSave();
    }

    protected ILaunchConfigurationType getRubyLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("com.aptana.ruby.debug.core.launchConfigurationType");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

